<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models
* @filesource
*//** */


/**
* @package direct-as-a-service
* @subpackage models
*/
class HispModel extends CI_Model {
	var $delimiter;
	var $http;
	var $https;
	var $right_angle_bracket;
	var $www;
    function __construct() {
        parent::__construct();
        $this->delimiter = '@';
        $this->http = 'http://';
        $this->https = 'https://';
        $this->right_angle_bracket = '>';
        $this->www = 'www.';
		$this->doublequote = '"';
		$this->singlequote = "'";
		$this->load->database();
    }
    
    function get_sent_message_counts_grouped_by_domain($application_id, $between) {
    	
    	$sql = "select (CASE WHEN count(*) > 0 THEN count(*) ELSE 0 END) as message_count, replace(replace(replace(RIGHT(ml.sender,CHARINDEX('@',REVERSE(ml.sender))-1), '>', ''),".$this->db->escape($this->doublequote).",''),".$this->db->escape($this->singlequote).",'') domain " .
			   'from mail_log ml ' . 
			   'where ml.success = 1 AND ml.inbound_outbound = 1';
		if($application_id!= null && $application_id != '(ALL)') {
			$sql .= "and LEN(ml.sender) > 0 AND (replace(replace(replace(RIGHT(ml.sender,CHARINDEX('@',REVERSE(ml.sender))-1), '>', ''),".$this->db->escape($this->doublequote).",''),".$this->db->escape($this->singlequote).",'')  = '". $application_id . "' OR '". $application_id . "' = '')";
		}
		if($between != null) {
		   	foreach ($between as $key => $value){//this if for anything that has an upper and lower boundary (ie date)
		   		if($value['end']){
		   			$sql .= "AND (ml.". $key ." <= ".$this->db->escape($value['end']).") ";
		   		}
		   		if($value['start']){
		   			$sql .= "AND (ml.". $key ." >= ".$this->db->escape($value['start']). ")";
		   		}
		   	}
		}
 		$sql .= "group by replace(replace(replace(RIGHT(ml.sender,CHARINDEX('@',REVERSE(ml.sender))-1), '>', ''),".$this->db->escape($this->doublequote).",''),".$this->db->escape($this->singlequote).",'')";
		return  $this->db->query($sql)->result();
    }
    
    function get_received_message_counts_grouped_by_domain($application_id, $between) {
    	
    	$sql = 'select recipient from mail_log ml where ml.success = 1 AND ml.inbound_outbound = 0';
    	if($between != null) {
    		foreach ($between as $key => $value){//this if for anything that has an upper and lower boundary (ie date)
    			if($value['end']){
    				$sql .= "AND (ml.". $key ." <= ".$this->db->escape($value['end']).") ";
    			}
    			if($value['start']){
    				$sql .= "AND (ml.". $key ." >= ".$this->db->escape($value['start']). ")";
    			}
    		}
    	}
    	//$sql .= 'order by id desc';
    	$recipient_arrays = $this->db->query($sql)->result();
    	if($application_id != null && $application_id != '(ALL)') {
    		$selected_application_domain = $this->get_domain_by_application_id($application_id);
    	}
    	$msg_counts_grouped_by_domains = array();
    	foreach($recipient_arrays as $recipient_array) {
    		$recipient_array = json_decode($recipient_array->recipient);
    		foreach($recipient_array as $recipient) {
				$recipient_domain = str_replace('>', '' ,explode("@", $recipient)[sizeof(explode("@", $recipient))-1]);
				if(array_key_exists($recipient_domain, $msg_counts_grouped_by_domains)) {
					if(isset($selected_application_domain)) {
						if($recipient_domain === $selected_application_domain) {
							$msg_counts_grouped_by_domains[$recipient_domain]++;
						}
					}
					else {
						$msg_counts_grouped_by_domains[$recipient_domain]++;
					}
				}
				else {
					if(isset($selected_application_domain)) {
						if($recipient_domain === $selected_application_domain) {
							$msg_counts_grouped_by_domains[$recipient_domain] = 1;
						}
					}
					else {
						$msg_counts_grouped_by_domains[$recipient_domain] = 1;
					}
				}		
    		}
    	}
    	return $msg_counts_grouped_by_domains;
    }
    
    function get_domain_by_application_id($application_id) {
		$sql = "SELECT replace(replace(replace(RIGHT(sender,CHARINDEX('@',REVERSE(sender))-1), '>', ''),".$this->db->escape($this->doublequote).",''),".$this->db->escape($this->singlequote).",'')  domain FROM [api].[dbo].[mail_log]	
				WHERE  LEN(sender) > 0
				AND LEN(sender) > 0 AND replace(replace(replace(RIGHT(sender,CHARINDEX('@',REVERSE(sender))-1), '>', ''),".$this->db->escape($this->doublequote).",''),".$this->db->escape($this->singlequote).",'')  = '".$application_id."'
				GROUP BY replace(replace(replace(RIGHT(sender,CHARINDEX('@',REVERSE(sender))-1), '>', ''),".$this->db->escape($this->doublequote).",''),".$this->db->escape($this->singlequote).",'') 
				ORDER BY replace(replace(replace(RIGHT(sender,CHARINDEX('@',REVERSE(sender))-1), '>', ''),".$this->db->escape($this->doublequote).",''),".$this->db->escape($this->singlequote).",'')  ASC";
    	return  $this->db->query($sql)->result()[0]->domain;
    }
    
    function get_domain_app_id_maps() {
		$sql = "SELECT replace(replace(replace(RIGHT(sender,CHARINDEX('@',REVERSE(sender))-1), '>', ''),".$this->db->escape($this->doublequote).",''),".$this->db->escape($this->singlequote).",'') domain, replace(replace(replace(RIGHT(sender,CHARINDEX('@',REVERSE(sender))-1), '>', ''),".$this->db->escape($this->doublequote).",''),".$this->db->escape($this->singlequote).",'')  application_id FROM [api].[dbo].[mail_log] 
				WHERE  LEN(sender) > 0
				GROUP BY replace(replace(replace(RIGHT(sender,CHARINDEX('@',REVERSE(sender))-1), '>', ''),".$this->db->escape($this->doublequote).",''),".$this->db->escape($this->singlequote).",'') 
				ORDER BY replace(replace(replace(RIGHT(sender,CHARINDEX('@',REVERSE(sender))-1), '>', ''),".$this->db->escape($this->doublequote).",''),".$this->db->escape($this->singlequote).",'')  ASC";
		return  $this->db->query($sql)->result();
    }
    
    function get_message_counts_grouped_by_domain($application_id = null, $between = null, $order, $dir, $destination_page, $items_per_page, $is_export) {
    	$sent_message_counts = $this->get_sent_message_counts_grouped_by_domain($application_id, $between);
    	$received_message_counts = $this->get_received_message_counts_grouped_by_domain($application_id, $between);
    	$msg_counts_grouped_by_domains = array();
    	$total_sent_by_all_doamins = 0;
    	$total_received_by_all_doamins = 0;
    	$total_by_all_doamins = 0;
    	foreach($sent_message_counts as $smc) {
    		$domain = $smc->domain;
    		$msg_counts_grouped_by_domains[$domain]['domain'] = $domain;
    		$msg_counts_grouped_by_domains[$domain]['sent'] = $smc->message_count;
    		$total_sent_by_all_doamins += $smc->message_count;
    		$msg_counts_grouped_by_domains[$domain]['received'] = 0;
			if (isset($msg_counts_grouped_by_domains[$domain]['sent']) == ''){
				$msg_counts_grouped_by_domains[$domain]['sent'] = 0;
			}
    		$msg_counts_grouped_by_domains[$domain]['total'] = $msg_counts_grouped_by_domains[$domain]['sent'] + $msg_counts_grouped_by_domains[$domain]['received'];
    		$total_by_all_doamins += $smc->message_count;
    	}
    	foreach($received_message_counts as $domain => $message_count) {
    		$msg_counts_grouped_by_domains[$domain]['domain'] = $domain;
    		$msg_counts_grouped_by_domains[$domain]['received'] = $message_count;
    		$total_received_by_all_doamins += $message_count;
    		if(!array_key_exists($domain, $msg_counts_grouped_by_domains)) {
    			$msg_counts_grouped_by_domains[$domain]['sent'] = 0;
    		}
			if (isset($msg_counts_grouped_by_domains[$domain]['sent']) == ''){
				$msg_counts_grouped_by_domains[$domain]['sent'] = 0;
			}
    		$msg_counts_grouped_by_domains[$domain]['total'] =  $msg_counts_grouped_by_domains[$domain]['sent'] + $msg_counts_grouped_by_domains[$domain]['received'];
    		$total_by_all_doamins += $message_count;
    	}
    	if($order != null && $dir != null) {
    		$this->_hisp_info_sort($msg_counts_grouped_by_domains, $order, $dir);
    	}
    	$total_size = sizeof($msg_counts_grouped_by_domains);
    	if($is_export) {
    		if($is_export === 'excel') {
	    		$msg_counts_grouped_by_domains['total_va']['domain'] = 'Total VA:';
	    		$msg_counts_grouped_by_domains['total_va']['sent'] = $total_sent_by_all_doamins;
	    		$msg_counts_grouped_by_domains['total_va']['received'] = $total_received_by_all_doamins;
	    		$msg_counts_grouped_by_domains['total_va']['total'] = $total_by_all_doamins;
    		}
    		return array('list'=>$msg_counts_grouped_by_domains, 'total_size'=>$total_size);
    	}
    	//get the content for the page
    	$paginated_msg_counts = array();
    	$start = ($destination_page - 1) * $items_per_page + 1;
    	$counter= 1;
    	foreach($msg_counts_grouped_by_domains as $doamin => $mc) {
    		if($counter >= $start && $counter < $start + $items_per_page) {
    			$paginated_msg_counts[$doamin] = $mc;
    		}
    		$counter++;
    	}
    	return array('list'=>$paginated_msg_counts, 'total_size'=>$total_size);
    }
    
    //sort the nested input array on the key column with the direction
    private function _hisp_info_sort(&$array, $key, $dir) {
    	if(strtoupper($key) == 'DOMAIN_NAME') {
    		if(strtoupper($dir) == 'ASC') {
    			ksort($array);
    		}
    		else {
    			krsort($array);
    		}
    	}
    	else {
	    	$sorter = array();
	    	$ret = array();
	    	reset($array);
	    	foreach($array as $ii => $va) {
	    		$sorter[$ii] = $va[$key];
	    	}
	    	$domains = array();
	    	$msg_count = array();
	    	foreach($sorter as $key => $value) {
	    		$domains[] = $key;
	    		$msg_count[] = $value;
	    	}
	    	if(strtoupper($dir) == 'ASC') {
	    		array_multisort($msg_count, SORT_ASC, $domains, SORT_ASC, $sorter);
	    	}
	    	else {
	    		array_multisort($msg_count, SORT_DESC, $domains, SORT_ASC, $sorter);
	    	}
	    	foreach($sorter as $ii => $va) {
	    		$ret[$ii] = $array[$ii];
	    	}
	    	$array = $ret;
    	}
    }
}
